from bpy.types import PropertyGroup
from bpy.props import IntProperty, FloatProperty, BoolProperty


class FLUIDLAB_DATA_Object_force_anim(PropertyGroup):
    
    """ properties objeto.fluidlab.force_anim """

    ##############################################################
    # Para poder Animar los Force sin force_group:
    ##############################################################
    
    # Strength:
    strength_name="Strength"
    strength_description="Strength of force field"
    strength_start: IntProperty(name="Start", default=1)
    strength_duration: IntProperty(name="Duration", description="Duration from the first two keyframes to the last two keyframes", default=10)
    strength_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    strength_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    strength_from: FloatProperty(name=strength_name, description=strength_description, default=0)
    strength_to: FloatProperty(name=strength_name, description=strength_description, default=1)
    strength_animed: BoolProperty(default=False)
    strength_inc_dec: BoolProperty(default=False)


    # Size:
    size_name="Size"
    size_description="Size of force Turbulence"
    size_start: IntProperty(name="Start", default=1)
    size_duration: IntProperty(name="Duration", description="Duration from the first two keyframes to the last two keyframes", default=10)
    size_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    size_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    size_from: FloatProperty(name=size_name, description=size_description, default=0, soft_min=0, soft_max=10)
    size_to: FloatProperty(name=size_name, description=size_description, default=1, soft_min=0, soft_max=10)
    size_animed: BoolProperty(default=False)
    size_inc_dec: BoolProperty(default=False)


    # Flow:
    flow_name="Flow"
    flow_description="Convert effector force into airflow velocity"
    flow_start: IntProperty(name="Start", default=1)
    flow_duration: IntProperty(name="Duration", description="Duration from the first two keyframes to the last two keyframes", default=10)
    flow_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    flow_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    flow_from: FloatProperty(name=flow_name, description=flow_description, default=0, soft_min=0, soft_max=10)
    flow_to: FloatProperty(name=flow_name, description=flow_description, default=1, soft_min=0, soft_max=10)
    flow_animed: BoolProperty(default=False)
    flow_inc_dec: BoolProperty(default=False)

    # Guide Free
    guide_free_name="Guide Free"
    guide_free_description="Guide-Free time from particle life's end"
    guide_free_start: IntProperty(name="Start", default=1)
    guide_free_duration: IntProperty(name="Duration", description="Duration from the first two keyframes to the last two keyframes", default=10)
    guide_free_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    guide_free_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    guide_free_from: FloatProperty(name=guide_free_name, description=guide_free_description, default=0, min=0, max=0.99)
    guide_free_to: FloatProperty(name=guide_free_name, description=guide_free_description, default=1, min=0, max=0.99)
    guide_free_animed: BoolProperty(default=False)
    guide_free_inc_dec: BoolProperty(default=False)

    # Falloff Power
    falloff_power_name="Falloff Power"
    falloff_power_description="How quickly strength fall off with distance from the force field"
    falloff_power_start: IntProperty(name="Start", default=1)
    falloff_power_duration: IntProperty(name="Duration", description="Duration from the first two keyframes to the last two keyframes", default=10)
    falloff_power_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    falloff_power_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    falloff_power_from: FloatProperty(name=falloff_power_name, description=falloff_power_description, default=0, min=0, max=10)
    falloff_power_to: FloatProperty(name=falloff_power_name, description=falloff_power_description, default=1, min=0, max=10)
    falloff_power_animed: BoolProperty(default=False)
    falloff_power_inc_dec: BoolProperty(default=False)

    # Linear Drag
    linear_drag_name="Linear Drag"
    linear_drag_description="Drag component proportional to velocity"
    linear_drag_start: IntProperty(name="Start", default=1)
    linear_drag_duration: IntProperty(name="Duration", description="Duration from the first two keyframes to the last two keyframes", default=10)
    linear_drag_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    linear_drag_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    linear_drag_from: FloatProperty(name=linear_drag_name, description=linear_drag_description, default=0, soft_min=-2, soft_max=2)
    linear_drag_to: FloatProperty(name=linear_drag_name, description=linear_drag_description, default=1, soft_min=-2, soft_max=2)
    linear_drag_animed: BoolProperty(default=False)
    linear_drag_inc_dec: BoolProperty(default=False)

    # Quadratic Drag
    quadratic_drag_name="Quadratic Drag"
    quadratic_drag_description="Drag component proportional to square of velocity"
    quadratic_drag_start: IntProperty(name="Start", default=1)
    quadratic_drag_duration: IntProperty(name="Duration", description="Duration from the first two keyframes to the last two keyframes", default=10)
    quadratic_drag_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    quadratic_drag_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    quadratic_drag_from: FloatProperty(name=quadratic_drag_name, description=quadratic_drag_description, default=0, soft_min=-2, soft_max=2)
    quadratic_drag_to: FloatProperty(name=quadratic_drag_name, description=quadratic_drag_description, default=1, soft_min=-2, soft_max=2)
    quadratic_drag_animed: BoolProperty(default=False)
    quadratic_drag_inc_dec: BoolProperty(default=False)

    # Harmonic Damping
    harmonic_damping_name="Harmonic Damping"
    harmonic_damping_description="Damping of the harmonic force"
    harmonic_damping_start: IntProperty(name="Start", default=1)
    harmonic_damping_duration: IntProperty(name="Duration", description="Duration from the first two keyframes to the last two keyframes", default=10)
    harmonic_damping_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    harmonic_damping_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    harmonic_damping_from: FloatProperty(name=harmonic_damping_name, description=harmonic_damping_description, default=0, soft_min=-100000000, soft_max=10, max=100000000)
    harmonic_damping_to: FloatProperty(name=harmonic_damping_name, description=harmonic_damping_description, default=1, soft_min=-100000000, soft_max=10, max=100000000)
    harmonic_damping_animed: BoolProperty(default=False)
    harmonic_damping_inc_dec: BoolProperty(default=False)

    # Rest Length
    rest_length_name="Rest Length"
    rest_length_description="Rest Length of the harmonic force"
    rest_length_start: IntProperty(name="Start", default=1)
    rest_length_duration: IntProperty(name="Duration", description="Duration from the first two keyframes to the last two keyframes", default=10)
    rest_length_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    rest_length_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    rest_length_from: FloatProperty(name=rest_length_name, description=rest_length_description, default=0, min=0, soft_max=1000.0)
    rest_length_to: FloatProperty(name=rest_length_name, description=rest_length_description, default=1, min=0, soft_max=1000.0)
    rest_length_animed: BoolProperty(default=False)
    rest_length_inc_dec: BoolProperty(default=False)